import React, { useEffect, useState } from 'react';
import { CheckCircleFilled } from '@ant-design/icons';
import { Button } from 'antd';
import { useRouter } from 'next/router';
import styled from 'styled-components';
import { HomeAPI } from '@/api';
import { InterDataType } from '@/api/interface';
import { RecommendGoodsType } from '@/api/interface/home';
import BreadcrumbView from '@/components/breadcrumb';
import LayoutView from '@/components/layout';
import ProductItemView from '@/components/productItem';

// 列表类型
type ListType = InterDataType<RecommendGoodsType>;

const OrderSuccessView = () => {
  // 路由钩子
  const router = useRouter();
  // 推荐商品列表
  const [recommendGoodsList, setRecommendGoodsList] = useState<
    ListType[0]['mallGoodsList']
  >([]);
  // 获取推荐商品
  const getRecommendGoodsList = async () => {
    const res = await HomeAPI.getRecommendGoods();
    if (res && res.code === '200') {
      const list = res.result || [];
      setRecommendGoodsList(
        list
          ?.map((i) => i.mallGoodsList)
          ?.flat()
          ?.slice(0, 10),
      );
    }
  };
  // 跳转订单详情
  const handleDetail = async () => {
    await router.push(`/order/product/${router.query?.id}`);
  };
  // 页面加载
  useEffect(() => {
    getRecommendGoodsList().then();
  }, []);
  return (
    <LayoutView>
      <OrderSuccessWrap>
        <BreadcrumbView />
        <div className="order-success">
          <div className="success-title">
            <CheckCircleFilled className="text-3xl text-[#54A536]" />
            <div className="title">您已成功付款</div>
          </div>
          <div className="success-content">
            <div className="content-item mb-2 flex">
              <div className="item-label">收货地址：</div>
              <div className="item-value">
                浙江省杭州市富阳区银湖街道富闲路15号浙大网新银湖科技园25幢{' '}
                吴彦祖 18888888888
              </div>
            </div>
            <div className="content-item mb-2 flex">
              <div className="item-label">实付款：</div>
              <div className="item-value price">￥19.9</div>
            </div>
            <Button type="link" className="mb-2 px-0" onClick={handleDetail}>
              查看订单
            </Button>
          </div>
        </div>
        <div className="order-product">
          {recommendGoodsList?.map((i, j) => (
            <ProductItemView key={j} detail={i as any} />
          ))}
        </div>
      </OrderSuccessWrap>
    </LayoutView>
  );
};

export default OrderSuccessView;
// 样式
const OrderSuccessWrap = styled.div`
  position: relative;
  max-width: 1190px;
  box-sizing: border-box;
  padding: 2rem 0 0 0;
  margin: 0 auto;
  .order-success {
    position: relative;
    width: 100%;
    box-sizing: border-box;
    min-height: 8.25rem;
    border: 0.02rem solid #e3e3e3;
    margin-bottom: 1rem;
    .success-title {
      position: relative;
      width: 100%;
      height: 3.5rem;
      background: #ecffdc;
      display: flex;
      justify-content: flex-start;
      align-items: center;
      box-sizing: border-box;
      padding: 0 5rem;
      margin-bottom: 1rem;
      .title {
        font-size: 16px;
        font-weight: bold;
        margin-left: 1rem;
      }
    }
    .success-content {
      position: relative;
      width: 100%;
      box-sizing: border-box;
      padding: 0 5rem;
      color: #999999;
      .price {
        color: #ea0000;
        font-weight: bold;
      }
    }
  }
  .order-product {
    position: relative;
    width: 100%;
    box-sizing: border-box;
    display: flex;
    justify-content: flex-start;
    flex-wrap: wrap;
    margin-bottom: 1rem;
  }
`;
